# -*- coding: utf-8 -*-

from core import httptools
from core import scrapertools
from core import urlparse
from platformcode import logger

import codecs
import sys

PY3 = sys.version_info >= (3,)

if PY3:
    from alfaresolver_py3 import failed_link
else:
    from alfaresolver import failed_link

def test_video_exists(page_url):
    if 'googleusercontent' in page_url:
        return True, "" # desactivada verificación pq se encalla!

    response = httptools.downloadpage(page_url, headers={"Referer": page_url})
    if PY3 and isinstance(response.data, bytes):
        response.data = response.data.decode('utf-8')
    global page
    page = response

    if "no+existe" in response.data or 'no existe.</p>' in response.data:
        return False, "[gvideo] El video no existe o ha sido borrado"
    if "No+tienes+permiso" in response.data:
        return False, "[gvideo] No tienes permiso para acceder a este video"
    if "Se ha producido un error" in response.data:
        return False, "[gvideo] Se ha producido un error en el reproductor de google"
    if "No+se+puede+procesar+este" in response.data:
        return False, "[gvideo] No se puede procesar este video"
    if response.code == 429:
        return False, "[gvideo] Demasiadas conexiones al servidor, inténtelo después"
    return True, ""


def get_video_url(page_url, user="", password="", video_password=""):
    logger.info()
    video_urls = []
    urls = []
    streams =[]
    logger.debug('page_url: %s'%page_url)
    try:
        if 'googleusercontent' in page_url:

            url = page_url
            headers_string = httptools.get_url_headers(page_url, forced=True)

            quality = scrapertools.find_single_match (url, '.itag=(\d+).')
            if not quality:
                quality = '59'
            streams.append((quality, url))

        else:

            data = page.data
            bloque= scrapertools.find_single_match(data, 'url_encoded_fmt_stream_map(.*)')
            
            if bloque:
                data = bloque
            
            #data = data.decode('unicode-escape', errors='replace')
            data = codecs.decode(data, 'unicode-escape')
            data = urlparse.unquote_plus(urlparse.unquote_plus(data))

            headers_string = httptools.get_url_headers(page_url, forced=True)
            streams = scrapertools.find_multiple_matches(data,
                                                         'itag=(\d+)&url=(.*?)(?:;.*?quality=.*?(?:,|&)|&quality=.*?(?:,|&))')

        itags = {'18': '360p', '22': '720p', '34': '360p', '35': '480p', '37': '1080p', '43': '360p', '59': '480p'}
        for itag, video_url in streams:
            if video_url not in urls:
                video_url += headers_string
                video_urls.append([itags.get(itag, ''), video_url])
                urls.append(video_url)
            video_urls.sort(key=lambda video_urls: int(video_urls[0].replace("p", "")))
    except Exception:
        pass
    if not video_urls:
        return failed_link(page_url)
    
    return video_urls
