[![Kodi version](https://img.shields.io/badge/kodi%20versions-19--20-blue)](https://kodi.tv/)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
![CI](https://github.com/SerenKodi/SerenDevelopment/workflows/CI/badge.svg?branch=v2-Development)
[![codecov](https://codecov.io/gh/SerenKodi/SerenDevelopment/branch/v2-Development/graph/badge.svg?token=LCX9WOPJ2M)](https://codecov.io/gh/SerenKodi/SerenDevelopment)
[![License: GPL3](https://img.shields.io/badge/License-GPL3-yellow.svg)](https://opensource.org/licenses/GPL-3.0)

# Seren (plugin.video.seren)

Seren is a multi-source addon for Kodi with the added ability to install custom provider modules. Unlike other Kodi addons which are generally built for a single service use, Seren allows users to connect to multiple online/offline services at once for their viewing with a single click.

## Contribution

Install all dependencies in requirements.txt
```shell
pip install -r requirements.txt
```

Configure hooks for automated pre commit changes:
```sh
pre-commit install
```
Ensure that `git` is available in your PATH

## FAQ

> #### How do I install a new provider?

In the settings menu of Seren you will find a providers tab. Inside this tab you will find the install provider package option.

> #### How do manage my providers?

Within Seren's settings, you will find the providers tab. Within this tab you can disable/enable single providers inside provide packs, enable/disable entire provider packages, enable/ disable automatic provider updates and manually for a update check for your providers.

> #### Seren won't show me season or episode lists and instead begins playing automatically?

Please disable the Auto Episode Resume setting in the general tab of Seren's settings.

> #### I'm experiencing an issue whilst using Seren. Where can I get help?
You can often find help from users in the Addons4Kodi subreddit or you are always welcome to log a github issue and I will contact you directly to investigate the issue.

## License

Licensed under The GPL License.


## [![Repography logo](https://images.repography.com/logo.svg)](https://repography.com) Recent activity [![Time period](https://images.repography.com/31557107/SerenKodi/SerenDevelopment/recent-activity/54b09eb47a7d1f063e1adf376fe18f03_badge.svg)](https://repography.com)
[![Timeline graph](https://images.repography.com/31557107/SerenKodi/SerenDevelopment/recent-activity/54b09eb47a7d1f063e1adf376fe18f03_timeline.svg)](https://github.com/SerenKodi/SerenDevelopment/commits)
[![Issue status graph](https://images.repography.com/31557107/SerenKodi/SerenDevelopment/recent-activity/54b09eb47a7d1f063e1adf376fe18f03_issues.svg)](https://github.com/SerenKodi/SerenDevelopment/issues)
[![Pull request status graph](https://images.repography.com/31557107/SerenKodi/SerenDevelopment/recent-activity/54b09eb47a7d1f063e1adf376fe18f03_prs.svg)](https://github.com/SerenKodi/SerenDevelopment/pulls)
[![Trending topics](https://images.repography.com/31557107/SerenKodi/SerenDevelopment/recent-activity/54b09eb47a7d1f063e1adf376fe18f03_words.svg)](https://github.com/SerenKodi/SerenDevelopment/commits)

