# -*- coding: utf-8 -*-
# modified by Venom for Fenomscrapers (updated 7-19-2022)
"""
	Fenomscrapers Project
"""

import re
from urllib.parse import quote_plus, quote
from cocoscrapers.modules import client
from cocoscrapers.modules import source_utils
from cocoscrapers.modules import workers
from cocoscrapers.modules import log_utils
# from cocoscrapers.modules.Thread_pool import run_and_wait
from functools import partial
from time import time

class source:
	priority = 5
	pack_capable = True
	hasMovies = True
	hasEpisodes = True
	def __init__(self):
		self.language = ['en']
		self.item_totals = {
			'4K': 0,
			'1080p': 0,
			'720p': 0,
			'SD': 0,
			'CAM': 0 
			}
		self.base_link = "https://www.limetorrents.lol"
		# self.base_link = "https://limetorrents.proxyninja.org" # if ever needed
		self.tvsearch = '/search/tv/{0}/1/'
		self.moviesearch = '/search/movies/{0}/1/'
		self.min_seeders = 0

	def sources(self, data, hostDict):
		self.sources = []
		if not data: return self.sources
		self.sources_append = self.sources.append
		try:
			startTime = time()
			self.aliases = data['aliases']
			self.year = data['year']
			urls = []
			if 'tvshowtitle' in data:
				self.title = data['tvshowtitle'].replace('&', 'and').replace('Special Victims Unit', 'SVU').replace('/', ' ').replace('$', 's')
				self.episode_title = data['title']
				self.hdlr = 'S%02dE%02d' % (int(data['season']), int(data['episode']))
				search_path = '/search/tv/{0}/1/'
			else:
				self.title = data['title'].replace('&', 'and').replace('/', ' ').replace('$', 's')
				self.episode_title = None
				self.hdlr = self.year
				search_path = '/search/movies/{0}/1/'
			query = '%s %s' % (re.sub(r'[^A-Za-z0-9\s\.-]+', '', self.title), self.hdlr)
			url = self.base_link + search_path.format(quote_plus(query))
			urls.append(url)
			urls.append(url.replace('/1/', '/2/'))
			self.undesirables = source_utils.get_undesirables()
			self.check_foreign_audio = source_utils.check_foreign_audio()
			# bound_get_sources = partial(self.get_sources)
			# run_and_wait(bound_get_sources,urls)
			threads = []
			append = threads.append
			for url in urls:
				append(workers.Thread(self.get_sources, url))
			[i.start() for i in threads]
			[i.join() for i in threads]
			logged = False
			for quality in self.item_totals:
				if self.item_totals[quality] > 0:
					log_utils.log('#STATS - Limetorrents found {0:2.0f} {1}'.format(self.item_totals[quality],quality) )
					logged = True
			if not logged: log_utils.log('#STATS - Limetorrents found nothing')
			endTime = time()
			log_utils.log('#STATS - Limetorrents took %.2f seconds' % (endTime - startTime))
			return self.sources
		except:
			source_utils.scraper_error('LIMETORRENTS')
			return self.sources

	def get_sources(self, link):
		# log_utils.log('link = %s' % link)
		try:
			results = client.request(link, timeout=7)
			if not results: return
			if '503 Service Temporarily Unavailable' in results:
				log_utils.log('LIMETORRENTS (Single request failure): 503 Service Temporarily Unavailable')
				return
			if '<table' not in results: return
			table = client.parseDOM(results, 'table', attrs={'class': 'table2'})[0]
			rows = client.parseDOM(table, 'tr')
			if not rows: return
		except:
			source_utils.scraper_error('LIMETORRENTS')
			return

		for row in rows:
			try:
				if '<th' in row: continue
				
				# Extract torrent detail page link
				detail_link = re.search(r'href="(/[^"]+-torrent-\d+\.html)"', row, re.I)
				if not detail_link: continue
				detail_url = self.base_link + quote(detail_link.group(1), safe='/')
				
				# Extract torrent name from the link text
				name_match = re.search(r'<a[^>]*href="[^"]*-torrent-\d+\.html"[^>]*>([^<]+)</a>', row, re.I)
				if not name_match: continue
				name = source_utils.clean_name(name_match.group(1))

				if not source_utils.check_title(self.title, self.aliases, name, self.hdlr, self.year): continue
				name_info = source_utils.info_from_name(name, self.title, self.year, self.hdlr, self.episode_title)
				if source_utils.remove_lang(name_info, self.check_foreign_audio): continue
				if self.undesirables and source_utils.remove_undesirables(name_info, self.undesirables): continue

				if not self.episode_title: # filter for eps returned in movie query (rare but movie and show exists for Run in 2020)
					ep_strings = [r'[.-]s\d{2}e\d{2}([.-]?)', r'[.-]s\d{2}([.-]?)', r'[.-]season[.-]?\d{1,2}[.-]?']
					name_lower = name.lower()
					if any(re.search(item, name_lower) for item in ep_strings): continue

				# Get magnet link from detail page
				try:
					detail_results = client.request(detail_url, timeout=7)
					if not detail_results: continue
					
					# Extract magnet link
					magnet_match = re.search(r'href="(magnet:[^"]+)"', detail_results, re.I)
					if not magnet_match: continue
					url = magnet_match.group(1)
					
					# Extract hash from magnet link
					hash_match = re.search(r'btih:([A-F0-9]+)', url, re.I)
					if not hash_match: continue
					hash = hash_match.group(1)
					
					# Extract seeders from detail page
					seeders_match = re.search(r'Seeders\s*:\s*(\d+)', detail_results, re.I)
					try:
						seeders = int(seeders_match.group(1)) if seeders_match else 0
						if self.min_seeders > seeders: continue
					except: seeders = 0
					
					# Extract size from detail page
					size_match = re.search(r'Torrent Size\s*:\s*</td>\s*<td>([^<]+)</td>', detail_results, re.I | re.DOTALL)
					if not size_match:
						# Try alternative pattern in case of different formatting
						size_match = re.search(r'<td[^>]*>([0-9.]+ [A-Za-z]+)</td>', detail_results, re.I)
					try:
						if size_match:
							size_text = size_match.group(1).strip()
							dsize, isize = source_utils._size(size_text)
						else:
							dsize = 0
							isize = '0'
					except Exception as e: 
						dsize = 0
						isize = '0'
						
				except:
					continue

				quality, info = source_utils.get_release_quality(name_info, url)
				if isize != '0': info.insert(0, isize)
				info = ' | '.join(info)

				self.sources_append({'provider': 'limetorrents', 'source': 'torrent', 'seeders': seeders, 'hash': hash, 'name': name, 'name_info': name_info,
												'quality': quality, 'language': 'en', 'url': url, 'info': info, 'direct': False, 'debridonly': True, 'size': dsize})
				self.item_totals[quality]+=1
			except:
				source_utils.scraper_error('LIMETORRENTS')

	def sources_packs(self, data, hostDict, search_series=False, total_seasons=None, bypass_filter=False):
		self.sources = []
		if not data: return self.sources
		self.sources_append = self.sources.append
		try:
			startTime = time()
			self.search_series = search_series
			self.total_seasons = total_seasons
			self.bypass_filter = bypass_filter

			self.title = data['tvshowtitle'].replace('&', 'and').replace('Special Victims Unit', 'SVU').replace('/', ' ').replace('$', 's')
			self.aliases = data['aliases']
			self.imdb = data['imdb']
			self.year = data['year']
			self.season_x = data['season']
			self.season_xx = self.season_x.zfill(2)
			self.undesirables = source_utils.get_undesirables()
			self.check_foreign_audio = source_utils.check_foreign_audio()

			query = re.sub(r'[^A-Za-z0-9\s\.-]+', '', self.title)
			if search_series:
				queries = [
						'/search/tv/%s/1/' % quote_plus(query + ' Season'),
						'/search/tv/%s/1/' % quote_plus(query + ' Complete')]
			else:
				queries = [
							'/search/tv/%s/1/' % quote_plus(query + ' S%s' % self.season_xx),
							'/search/tv/%s/1/' % quote_plus(query + ' Season %s' % self.season_x)]
			# links = []
			# for url in queries:
			# 	link = ('%s%s' % (self.base_link, url)).replace('+', '-')
			# 	links.append(link)
			# bound_get_sources_packs = partial(self.get_sources_packs)
			# run_and_wait(bound_get_sources_packs,links)
			threads = []
			append = threads.append
			for url in queries:
				link = ('%s%s' % (self.base_link, url)).replace('+', '-')
				append(workers.Thread(self.get_sources_packs, link))
			[i.start() for i in threads]
			[i.join() for i in threads]
			logged = False
			for quality in self.item_totals:
				if self.item_totals[quality] > 0:
					log_utils.log('#STATS - Limetorrents(pack) found {0:2.0f} {1}'.format(self.item_totals[quality],quality) )
					logged = True
			if not logged: log_utils.log('#STATS - Limetorrents(pack) found nothing')
			endTime = time()
			log_utils.log('#STATS - Limetorrents(pack) took %.2f seconds' % (endTime - startTime))
			return self.sources
		except:
			source_utils.scraper_error('LIMETORRENTS')
			return self.sources

	def get_sources_packs(self, link):
		try:
			results = client.request(link, timeout=7)
			if not results: return
			if '503 Service Temporarily Unavailable' in results:
				req_type = 'SHOW' if self.search_series else 'SEASON'
				log_utils.log('LIMETORRENTS (%s Pack request failure): 503 Service Temporarily Unavailable' % req_type)
				return
			if '<table' not in results: return
			table = client.parseDOM(results, 'table', attrs={'class': 'table2'})[0]
			rows = client.parseDOM(table, 'tr')
			if not rows: return
		except:
			source_utils.scraper_error('LIMETORRENTS')
			return

		for row in rows:
			try:
				if '<th' in row: continue
				
				# Extract torrent detail page link
				detail_link = re.search(r'href="(/[^"]+-torrent-\d+\.html)"', row, re.I)
				if not detail_link: continue
				detail_url = self.base_link + quote(detail_link.group(1), safe='/')
				
				# Extract torrent name from the link text
				name_match = re.search(r'<a[^>]*href="[^"]*-torrent-\d+\.html"[^>]*>([^<]+)</a>', row, re.I)
				if not name_match: continue
				name = source_utils.clean_name(name_match.group(1))
				
				episode_start, episode_end = 0, 0
				if not self.search_series:
					if not self.bypass_filter:
						valid, episode_start, episode_end = source_utils.filter_season_pack(self.title, self.aliases, self.year, self.season_x, name)
						if not valid: continue
					package = 'season'

				elif self.search_series:
					if not self.bypass_filter:
						valid, last_season = source_utils.filter_show_pack(self.title, self.aliases, self.imdb, self.year, self.season_x, name, self.total_seasons)
						if not valid: continue
					else: last_season = self.total_seasons
					package = 'show'

				name_info = source_utils.info_from_name(name, self.title, self.year, season=self.season_x, pack=package)
				if source_utils.remove_lang(name_info, self.check_foreign_audio): continue
				if self.undesirables and source_utils.remove_undesirables(name_info, self.undesirables): continue

				# Get magnet link from detail page
				try:
					detail_results = client.request(detail_url, timeout=7)
					if not detail_results: continue
					
					# Extract magnet link
					magnet_match = re.search(r'href="(magnet:[^"]+)"', detail_results, re.I)
					if not magnet_match: continue
					url = magnet_match.group(1)
					
					# Extract hash from magnet link
					hash_match = re.search(r'btih:([A-F0-9]+)', url, re.I)
					if not hash_match: continue
					hash = hash_match.group(1)
					
					# Extract seeders from detail page
					seeders_match = re.search(r'Seeders\s*:\s*(\d+)', detail_results, re.I)
					try:
						seeders = int(seeders_match.group(1)) if seeders_match else 0
						if self.min_seeders > seeders: continue
					except: seeders = 0
					
					# Extract size from detail page
					size_match = re.search(r'Torrent Size\s*:\s*</td>\s*<td>([^<]+)</td>', detail_results, re.I | re.DOTALL)
					if not size_match:
						# Try alternative pattern in case of different formatting
						size_match = re.search(r'<td[^>]*>([0-9.]+ [A-Za-z]+)</td>', detail_results, re.I)
					try:
						if size_match:
							size_text = size_match.group(1).strip()
							dsize, isize = source_utils._size(size_text)
						else:
							dsize = 0
							isize = '0'
					except Exception as e: 
						dsize = 0
						isize = '0'
						
				except:
					continue

				quality, info = source_utils.get_release_quality(name_info, url)
				if isize != '0': info.insert(0, isize)
				info = ' | '.join(info)

				item = {'provider': 'limetorrents', 'source': 'torrent', 'seeders': seeders, 'hash': hash, 'name': name, 'name_info': name_info, 'quality': quality,
							'language': 'en', 'url': url, 'info': info, 'direct': False, 'debridonly': True, 'size': dsize, 'package': package}
				if self.search_series: item.update({'last_season': last_season})
				elif episode_start: item.update({'episode_start': episode_start, 'episode_end': episode_end}) # for partial season packs
				self.sources_append(item)
				self.item_totals[quality]+=1
			except:
				source_utils.scraper_error('LIMETORRENTS')
